<?php

try {

    // Tworzy kanwę
    $canvas = new Imagick();

    // Tworzy zmienną odpowiadającą niebieskiemu pikselowi
    $blue = new ImagickPixel("DarkBlue");

    // Tworzy nowy obraz
    $canvas->newImage( 800, 200, $blue);

    // Pobiera współrzędne z pliku
    $handle = fopen("comments.csv", "r");
    $cts = fgetcsv($handle, 1000, ",");
    fclose($handle);

    if ($cts) {
       $x = 0;
       $points = array();
       $ctr = 0;
   
       // Tworzy tablicę punktów
       foreach ($cts as $ct) {
         $y = 150 - $ct;
         $point = array('x' => $x, 'y' => $y); 
         $points[$ctr] = $point;
         $x += 10;
         $ctr++;
      }
    }
 
    // Tworzy obiekt rysowania, ustala kolor pędzla i wypełnienia 
    $draw = new ImagickDraw();
    $draw->setStrokeColor(new ImagickPixel("yellow"));
    $draw->setStrokeWidth(2);
    $draw->setFillColor($blue);

    // Rysuje łamaną
    $draw->polyline($points);

    // Rysuje obraz na kanwie
    $canvas->drawImage($draw);
 
    // Określa format pliku - PNG
    $canvas->setImageFormat( "png" );

    // Drukuje obraz
    header( "Content-Type: image/png" );
   
    // Wysyła obraz do przeglądarki
    echo $canvas;


} catch(ImagickException $e) {
   echo "Wystąpiły problemy z plikiem graficznym ", $e->getMessage, "\n";
}
?>
